/**  @file bta_avg_pixels.h
*
*    @brief This file implements the averaging of all pixels of the input frame
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_AVG_PIXELS_H_INCLUDED
#define BTA_AVG_PIXELS_H_INCLUDED


typedef struct BTA_FltAvgPixelsInst {
	BTA_ChannelId channelToProcess;
	BTA_ChannelId channelIdResult;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltAvgPixelsInst;


BTA_Status BFLTavgPixelsInit(BTA_FltAvgPixelsConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTavgPixelsClose(BTA_FltHandle *handle);
BTA_Status BFLTavgPixelsApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
